/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.compat.emi;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.AgriClientApi;
import com.agricraft.agricraft.api.codecs.AgriSoilCondition;
import com.agricraft.agricraft.api.crop.AgriGrowthStage;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.api.requirement.AgriGrowthConditionRegistry;
import com.agricraft.agricraft.api.requirement.AgriSeason;
import com.agricraft.agricraft.common.item.AgriSeedItem;
import com.agricraft.agricraft.common.util.LangUtils;
import com.agricraft.agricraft.common.util.Platform;
import com.agricraft.agricraft.compat.emi.AgriCraftEmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.ButtonWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

public class CropRequirementRecipe
implements EmiRecipe {
    public static final EmiTexture BACKGROUND = new EmiTexture(new class_2960("agricraft", "textures/gui/jei/crop_requirement.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final EmiTexture COMPONENTS = new EmiTexture(new class_2960("agricraft", "textures/gui/jei/crop_requirement.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final EmiTexture GUI_COMPONENTS = new EmiTexture(new class_2960("agricraft", "textures/gui/jei/crop_requirement_components.png"), 0, 0, 128, 128, 128, 128, 128, 128);
    public static final class_2960 R_COMPONENTS = new class_2960("agricraft", "textures/gui/jei/crop_requirement_components.png");
    public static final class_2960 R_GUI_COMPONENTS = new class_2960("agricraft", "textures/gui/gui_components.png");
    public static final int[] HUMIDITY_OFFSETS = new int[]{8, 8, 10, 10, 10, 7};
    public static final int[] ACIDITY_OFFSETS = new int[]{7, 8, 7, 8, 8, 8, 6};
    public static final int[] NUTRIENTS_OFFSETS = new int[]{6, 8, 9, 9, 11, 10};
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final AgriPlant plant;
    private final List<EmiStack> output;
    private final String plantId;
    public final Btn incStrButton;
    public final Btn decStrButton;
    public final Btn incStageButton;
    public final Btn decStageButton;
    private int currentStrength = AgriApi.getStatRegistry().strengthStat().getMin();
    private AgriGrowthStage currentStage;
    private List<class_2248> soils;
    private int soil;
    public long lastTime;

    public CropRequirementRecipe(class_2960 id, AgriPlant plant) {
        this.id = id;
        this.input = List.of(EmiStack.of((class_1799)AgriSeedItem.toStack(plant)).comparison(AgriCraftEmiPlugin.compareSeeds()));
        this.plant = plant;
        this.output = new ArrayList<EmiStack>();
        this.plantId = AgriApi.getPlantId(plant).map(class_2960::toString).orElse("");
        this.currentStage = plant.getInitialGrowthStage();
        this.incStrButton = new Btn(104, 10, 9, 9, this::incrementStrength, true);
        this.decStrButton = new Btn(104, 71, 9, 9, this::decrementStrength, false);
        this.incStageButton = new Btn(92, 10, 9, 9, this::incrementStage, true);
        this.decStageButton = new Btn(92, 71, 9, 9, this::decrementStage, false);
        this.updateSoils();
        this.lastTime = System.currentTimeMillis();
    }

    public EmiRecipeCategory getCategory() {
        return AgriCraftEmiPlugin.REQUIREMENT_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 128;
    }

    public int getDisplayHeight() {
        return 128;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0);
        widgets.addSlot(this.input.get(0), 55, 2).drawBack(false);
        widgets.add((Widget)this.incStrButton);
        widgets.add((Widget)this.decStrButton);
        widgets.add((Widget)this.incStageButton);
        widgets.add((Widget)this.decStageButton);
        widgets.addDrawable(0, 0, 128, 128, (guiGraphics, mouseX, mouseY, partialTick) -> {
            long l;
            int i;
            int offset;
            int index;
            for (int i2 = 0; i2 < this.currentStrength; ++i2) {
                guiGraphics.method_25290(R_COMPONENTS, 105, 66 - i2 * 5, 0.0f, 66.0f, 7, 3, 128, 128);
            }
            int maxHeight = 48;
            int stageHeight = (int)((double)maxHeight * this.currentStage.growthPercentage());
            int stageY = 21 + maxHeight - stageHeight;
            guiGraphics.method_25293(R_COMPONENTS, 93, stageY, 7, stageHeight, 0.0f, 69.0f, 7, 1, 128, 128);
            for (int i3 = 15; i3 >= 0; --i3) {
                boolean fertile = AgriGrowthConditionRegistry.getLight().apply(this.plant, this.currentStrength, i3).isFertile();
                if (!fertile) continue;
                guiGraphics.method_25293(R_COMPONENTS, 32, 26 + 3 * (15 - i3), 3, 3, 0.0f, (float)(18 + 3 * (15 - i3)), 3, 3, 128, 128);
            }
            for (AgriSoilCondition.Humidity humidity : AgriSoilCondition.Humidity.values()) {
                if (!humidity.isValid() || !AgriGrowthConditionRegistry.getHumidity().apply(this.plant, this.currentStrength, humidity).isFertile()) continue;
                index = humidity.ordinal();
                offset = 0;
                for (i = 0; i < index; ++i) {
                    offset += HUMIDITY_OFFSETS[i];
                }
                guiGraphics.method_25293(R_GUI_COMPONENTS, 37 + offset, 83, HUMIDITY_OFFSETS[index], 12, (float)offset, 0.0f, HUMIDITY_OFFSETS[index], 12, 128, 128);
            }
            for (Enum enum_ : AgriSoilCondition.Acidity.values()) {
                if (!((AgriSoilCondition.Acidity)enum_).isValid() || !AgriGrowthConditionRegistry.getAcidity().apply(this.plant, this.currentStrength, (AgriSoilCondition.Acidity)enum_).isFertile()) continue;
                index = enum_.ordinal();
                offset = 0;
                for (i = 0; i < index; ++i) {
                    offset += ACIDITY_OFFSETS[i];
                }
                guiGraphics.method_25293(R_GUI_COMPONENTS, 37 + offset, 96, ACIDITY_OFFSETS[index], 12, (float)offset, 12.0f, ACIDITY_OFFSETS[index], 12, 128, 128);
            }
            for (Enum enum_ : AgriSoilCondition.Nutrients.values()) {
                if (!((AgriSoilCondition.Nutrients)enum_).isValid() || !AgriGrowthConditionRegistry.getNutrients().apply(this.plant, this.currentStrength, (AgriSoilCondition.Nutrients)enum_).isFertile()) continue;
                index = enum_.ordinal();
                offset = 0;
                for (i = 0; i < index; ++i) {
                    offset += NUTRIENTS_OFFSETS[i];
                }
                guiGraphics.method_25293(R_GUI_COMPONENTS, 37 + offset, 109, NUTRIENTS_OFFSETS[index], 12, (float)offset, 24.0f, NUTRIENTS_OFFSETS[index], 12, 128, 128);
            }
            if (AgriApi.getSeasonLogic().isActive()) {
                for (Enum enum_ : AgriSeason.values()) {
                    if (enum_ == AgriSeason.ANY || !AgriGrowthConditionRegistry.getSeason().apply(this.plant, this.currentStrength, (AgriSeason)enum_).isFertile()) continue;
                    guiGraphics.method_25290(R_GUI_COMPONENTS, 17, 24 + 13 * enum_.ordinal(), (float)(10 * enum_.ordinal()), 44.0f, 10, 12, 128, 128);
                }
            }
            if (this.lastTime + 1500L <= (l = System.currentTimeMillis()) && !class_437.method_25442()) {
                ++this.soil;
                if (this.soil >= this.soils.size()) {
                    this.soil = 0;
                }
                this.lastTime = l;
            }
            class_4587 stack = guiGraphics.method_51448();
            stack.method_22903();
            class_308.method_24210();
            stack.method_46416(56.0f, 53.0f, 0.0f);
            stack.method_46416(-4.0f, 12.0f, 0.0f);
            stack.method_22905(16.0f, -16.0f, 1.0f);
            stack.method_22907(class_7833.field_40714.rotationDegrees(45.0f));
            stack.method_22907(class_7833.field_40716.rotationDegrees(45.0f));
            class_4597.class_4598 class_45982 = class_310.method_1551().method_22940().method_23000();
            if (!this.soils.isEmpty() && this.soil < this.soils.size()) {
                stack.method_22903();
                class_310.method_1551().method_1541().method_3353(this.soils.get(this.soil).method_9564(), stack, (class_4597)class_45982, 0xF000F0, class_4608.field_21444);
                stack.method_22909();
            }
            class_1087 model = AgriClientApi.getPlantModel(this.plantId, this.currentStage.index());
            stack.method_22903();
            stack.method_46416(0.0f, 1.0f, 0.0f);
            class_310.method_1551().method_1541().method_3350().method_3367(stack.method_23760(), guiGraphics.method_51450().getBuffer(class_1921.method_23579()), null, model, 1.0f, 1.0f, 1.0f, 0xF000F0, class_4608.field_21444);
            stack.method_22909();
            class_45982.method_22993();
            stack.method_22909();
        });
        widgets.addTooltip((mouseX, mouseY) -> List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"agricraft.tooltip.jei.strength", (Object[])new Object[]{this.currentStrength}).method_30937())), 104, 20, 9, 50);
        widgets.addTooltip((mouseX, mouseY) -> List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"agricraft.tooltip.jei.stage", (Object[])new Object[]{this.currentStage.index()}).method_30937())), 92, 20, 9, 50);
        widgets.addTooltip((mouseX, mouseY) -> List.of(class_5684.method_32662((class_5481)class_2561.method_43469((String)"agricraft.tooltip.jei.light", (Object[])new Object[]{15 - (mouseY - 26) / 3}).method_30937())), 32, 26, 3, 47);
        widgets.addTooltip((mouseX, mouseY) -> {
            int offset = 0;
            for (int i = 0; i < HUMIDITY_OFFSETS.length; ++i) {
                if (37 + offset <= mouseX && mouseX <= 37 + offset + HUMIDITY_OFFSETS[i]) {
                    AgriSoilCondition.Humidity humidity = AgriSoilCondition.Humidity.values()[i];
                    return List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)("agricraft.soil.humidity." + humidity.name().toLowerCase())).method_30937()));
                }
                offset += HUMIDITY_OFFSETS[i];
            }
            return List.of();
        }, 37, 83, 53, 12);
        widgets.addTooltip((mouseX, mouseY) -> {
            int offset = 0;
            for (int i = 0; i < ACIDITY_OFFSETS.length; ++i) {
                if (37 + offset <= mouseX && mouseX <= 37 + offset + ACIDITY_OFFSETS[i]) {
                    AgriSoilCondition.Acidity acidity = AgriSoilCondition.Acidity.values()[i];
                    return List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)("agricraft.soil.acidity." + acidity.name().toLowerCase())).method_30937()));
                }
                offset += ACIDITY_OFFSETS[i];
            }
            return List.of();
        }, 37, 96, 52, 12);
        widgets.addTooltip((mouseX, mouseY) -> {
            int offset = 0;
            for (int i = 0; i < NUTRIENTS_OFFSETS.length; ++i) {
                if (37 + offset <= mouseX && mouseX <= 37 + offset + NUTRIENTS_OFFSETS[i]) {
                    AgriSoilCondition.Nutrients nutrients = AgriSoilCondition.Nutrients.values()[i];
                    return List.of(class_5684.method_32662((class_5481)class_2561.method_43471((String)("agricraft.soil.nutrients." + nutrients.name().toLowerCase())).method_30937()));
                }
                offset += NUTRIENTS_OFFSETS[i];
            }
            return List.of();
        }, 37, 109, 53, 12);
        class_2561 desc = LangUtils.plantDescription(this.plantId);
        widgets.addTooltipText(desc == null ? List.of(LangUtils.plantName(this.plantId)) : List.of(LangUtils.plantName(this.plantId), desc), 50, 30, 26, 24);
        if (!this.soils.isEmpty() && this.soil < this.soils.size()) {
            widgets.addTooltip((mouseX, mouseY) -> class_437.method_25408((class_310)class_310.method_1551(), (class_1799)new class_1799((class_1935)this.soils.get(this.soil))).stream().map(class_2561::method_30937).map(class_5684::method_32662).toList(), 50, 58, 26, 16);
        }
        if (AgriApi.getSeasonLogic().isActive()) {
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.SPRING)), 17, 24, 12, 12);
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.SUMMER)), 17, 37, 12, 12);
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.AUTUMN)), 17, 50, 12, 12);
            widgets.addTooltipText(List.of(LangUtils.seasonName(AgriSeason.WINTER)), 17, 63, 12, 12);
        }
    }

    public boolean incrementStrength() {
        this.currentStrength = Math.min(AgriApi.getStatRegistry().strengthStat().getMax(), this.currentStrength + 1);
        this.updateSoils();
        return true;
    }

    public boolean decrementStrength() {
        this.currentStrength = Math.max(AgriApi.getStatRegistry().strengthStat().getMin(), this.currentStrength - 1);
        this.updateSoils();
        return true;
    }

    public boolean incrementStage() {
        this.currentStage = this.currentStage.getNext(null, null);
        return true;
    }

    public boolean decrementStage() {
        this.currentStage = this.currentStage.getPrevious(null, null);
        return true;
    }

    public void updateSoils() {
        this.soils = AgriApi.getSoilRegistry().map(registry -> registry.method_10220().filter(soil -> {
            boolean humidity = AgriGrowthConditionRegistry.getHumidity().apply(this.plant, this.currentStrength, soil.humidity()).isFertile();
            boolean acidity = AgriGrowthConditionRegistry.getAcidity().apply(this.plant, this.currentStrength, soil.acidity()).isFertile();
            boolean nutrients = AgriGrowthConditionRegistry.getNutrients().apply(this.plant, this.currentStrength, soil.nutrients()).isFertile();
            return humidity && acidity && nutrients;
        }).flatMap(soil -> soil.variants().stream()).flatMap(variant -> Platform.get().getBlocksFromLocation(variant.block()).stream()).distinct().toList()).orElse(List.of());
        this.soil = 0;
    }

    public static class Btn
    extends ButtonWidget {
        private final boolean isIncrement;

        protected Btn(int x, int y, int width, int height, BooleanSupplier onPress, boolean isIncrement) {
            super(x, y, width, height, 0, 0, () -> true, (mouseX, mouseY, button) -> onPress.getAsBoolean());
            this.isIncrement = isIncrement;
        }

        private int getUOffset(boolean isHovered) {
            if (class_310.method_1551().field_1729.method_1608()) {
                return 9;
            }
            if (isHovered) {
                return 18;
            }
            return 0;
        }

        public void render(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
            int vOffset = this.isIncrement ? 9 : 0;
            boolean isHovered = this.x <= mouseX && mouseX < this.x + this.width && this.y <= mouseY && mouseY < this.y + this.height;
            int uOffset = this.getUOffset(isHovered);
            guiGraphics.method_25290(R_COMPONENTS, this.x, this.y, (float)uOffset, (float)vOffset, 9, 9, 128, 128);
        }
    }
}

